cd "C:\Shazam\AER"
log using "vc-out-med-BM-01-11-16", replace
* AER VC SFA model and CIs
* Australia & NZ updated 1 year to 2015, Ontario updated 1 year to 2014
version 11
clear
set more off
set maxiter 200
import excel "DNSPData AusNZOnt 1Nov2016x BM.xlsx", sheet("DNSPAUNZONMed") firstrow
summarize
correlate Energy CustNum CircLen RMDemand

generate DNSP=0
replace DNSP=int(EIID/100) if Country==1
replace DNSP=EIID-2000+13 if Country==2
replace DNSP=EIID-3000+36 if Country==3

xtset DNSP Year

* adjust to calendar year
generate yr=Year
replace yr=yr+0.5 if DNSP==3
replace yr=yr+0.5 if DNSP==8
replace yr=yr+0.5 if DNSP==9
replace yr=yr+0.5 if DNSP==11
replace yr=yr+0.5 if DNSP==13
replace yr=yr-0.25 if Country==2
replace yr=yr+0.5 if Country==3

* adjust base to 2012
replace PrOpex=PrOpex/1.242220559 if Country==1
replace PrOpex=PrOpex/1.221665248 if Country==2
replace PrOpex=PrOpex/1.162050691 if Country==3

* adjust for PPPs in 2012
* Australia PPP = 1.527404363
* NZ PPP = 1.482877481
* Canada PPP = 1.249076963
* converting into Australian Dollar base
replace PrOpex=PrOpex*1.482877481/1.527404363 if Country==2
replace PrOpex=PrOpex*1.249076963/1.527404363 if Country==3

generate vc=Opex/PrOpex
generate lvc=log(vc)

generate uc1=vc/Energy
generate uc2=vc/CustNum
generate uc3=vc/CircLen
generate uc4=vc/RMDemand
generate obs=DNSP*10+Year-2004
*scatter uc1 obs, saving(uc1)
*scatter uc2 obs, saving(uc2)
*scatter uc3 obs, saving(uc3)
*scatter uc4 obs, saving(uc4)

generate ly1=log(Energy)
generate ly2=log(CustNum)
generate ly3=log(CircLen)
generate ly4=log(RMDemand)

generate z1=ShareUGC

generate lz1=log(z1)

* mean correct output data
qui reg ly1
predict mly1
replace ly1=ly1-mly1
qui reg ly2
predict mly2
replace ly2=ly2-mly2
qui reg ly3
predict mly3
replace ly3=ly3-mly3
qui reg ly4
predict mly4
replace ly4=ly4-mly4

generate cd2=0
replace cd2=1 if Country==2
generate cd3=0
replace cd3=1 if Country==3

generate ly11=ly1*ly1/2
generate ly22=ly2*ly2/2
generate ly33=ly3*ly3/2
generate ly44=ly4*ly4/2
generate ly12=ly1*ly2
generate ly13=ly1*ly3
generate ly14=ly1*ly4
generate ly23=ly2*ly3
generate ly24=ly2*ly4
generate ly34=ly3*ly4

* construct dummy variables
qui tabulate DNSP, gen(d)

* models with 4 outputs:

regress lvc ly1-ly4 lz1 yr cd2 cd3
regress lvc ly1-ly4 ly11 ly12 ly13 ly14 ly22 ly23 ly24 ly33 ly34 ly44 lz1 yr cd2 cd3


regress lvc ly1-ly4 lz1 yr cd2 cd3 d2-d13
regress lvc ly1-ly4 ly11 ly12 ly13 ly14 ly22 ly23 ly24 ly33 ly34 ly44 lz1 yr cd2 cd3 d2-d13

xtpcse lvc ly1-ly4 lz1 yr cd2 cd3 d2-d13, c(a) het
xtpcse lvc ly1-ly4 ly11 ly12 ly13 ly14 ly22 ly23 ly24 ly33 ly34 ly44 lz1 yr cd2 cd3 d2-d13, c(a) het

set matsize 1000
matrix bh=e(b)
matlist bh
mkmat ly1
mkmat ly2
mkmat ly3
mkmat ly4
generate c=1
mkmat c
matrix e1=c*bh[1,1]+ly1*bh[1,5]+ly2*bh[1,6]+ly3*bh[1,7]+ly4*bh[1,8]
matrix e2=c*bh[1,2]+ly1*bh[1,6]+ly2*bh[1,9]+ly3*bh[1,10]+ly4*bh[1,11]
matrix e3=c*bh[1,3]+ly1*bh[1,7]+ly2*bh[1,10]+ly3*bh[1,12]+ly4*bh[1,13]
matrix e4=c*bh[1,4]+ly1*bh[1,8]+ly2*bh[1,11]+ly3*bh[1,13]+ly4*bh[1,14]
matrix elas = e1, e2, e3, e4
matrix list elas


xtfrontier lvc ly1-ly4 lz1 yr cd2 cd3, ti cost
predict ci,te
frontier_teci ci
generate ceff=1/ci
generate ceff_l=1/ci_u
generate ceff_u=1/ci_l
list DNSP Year ceff ceff_l ceff_u
summarize DNSP Year ceff ceff_l ceff_u

generate ceffcd=ceff

drop ci ci_u ci_l ceff ceff_l ceff_u

qui reg lvc ly1-ly4 ly11 ly12 ly13 ly14 ly22 ly23 ly24 ly33 ly34 ly44 lz1 yr cd2 cd3
matrix b0 = e(b), .1, ln(e(rmse)^2) , .1
xtfrontier lvc ly1-ly4 ly11 ly12 ly13 ly14 ly22 ly23 ly24 ly33 ly34 ly44 lz1 yr cd2 cd3, ti cost from(b0, copy)
predict ci,te
frontier_teci ci
generate ceff=1/ci
generate ceff_l=1/ci_u
generate ceff_u=1/ci_l
list DNSP Year ceff ceff_l ceff_u
summarize DNSP Year ceff ceff_l ceff_u

generate cefftl=ceff

drop ci ci_u ci_l ceff ceff_l ceff_u

list cefftl ceffcd
summarize DNSP Year cefftl ceffcd

drop  cefftl ceffcd

matrix bh=e(b)
matlist bh
matrix e1=c*bh[1,1]+ly1*bh[1,5]+ly2*bh[1,6]+ly3*bh[1,7]+ly4*bh[1,8]
matrix e2=c*bh[1,2]+ly1*bh[1,6]+ly2*bh[1,9]+ly3*bh[1,10]+ly4*bh[1,11]
matrix e3=c*bh[1,3]+ly1*bh[1,7]+ly2*bh[1,10]+ly3*bh[1,12]+ly4*bh[1,13]
matrix e4=c*bh[1,4]+ly1*bh[1,8]+ly2*bh[1,11]+ly3*bh[1,13]+ly4*bh[1,14]
matrix elas = e1, e2, e3, e4
matrix list elas

* models with 3 outputs:

regress lvc ly2-ly4 lz1 yr cd2 cd3
regress lvc ly2-ly4 ly22 ly23 ly24 ly33 ly34 ly44 lz1 yr cd2 cd3

regress lvc ly2-ly4 lz1 yr cd2 cd3 d2-d13
regress lvc ly2-ly4 ly22 ly23 ly24 ly33 ly34 ly44 lz1 yr cd2 cd3 d2-d13

xtpcse lvc ly2-ly4 lz1 yr cd2 cd3 d2-d13, c(a) het
xtpcse lvc ly2-ly4 ly22 ly23 ly24 ly33 ly34 ly44 lz1 yr cd2 cd3 d2-d13, c(a) het

matrix bh3=e(b)
matlist bh3
matrix e1=c*0
matrix e2=c*bh3[1,1]+ly1*0+ly2*bh3[1,4]+ly3*bh3[1,5]+ly4*bh3[1,6]
matrix e3=c*bh3[1,2]+ly1*0+ly2*bh3[1,5]+ly3*bh3[1,7]+ly4*bh3[1,8]
matrix e4=c*bh3[1,3]+ly1*0+ly2*bh3[1,6]+ly3*bh3[1,8]+ly4*bh3[1,9]
matrix elas = e1, e2, e3, e4
matrix list elas

xtfrontier lvc ly2-ly4 lz1 yr cd2 cd3, ti cost 
predict ci,te
frontier_teci ci
generate ceff=1/ci
generate ceff_l=1/ci_u
generate ceff_u=1/ci_l
list DNSP Year ceff ceff_l ceff_u
summarize DNSP Year ceff ceff_l ceff_u

generate ceffcd=ceff

drop ci ci_u ci_l ceff ceff_l ceff_u

qui reg lvc ly2-ly4 ly22 ly23 ly24 ly33 ly34 ly44 lz1 yr cd2 cd3
matrix b0 = e(b), .1, ln(e(rmse)^2) , .1
xtfrontier lvc ly2-ly4 ly22 ly23 ly24 ly33 ly34 ly44 lz1 yr cd2 cd3, ti cost from(b0, copy)
predict ci,te
frontier_teci ci
generate ceff=1/ci
generate ceff_l=1/ci_u
generate ceff_u=1/ci_l
list DNSP Year ceff ceff_l ceff_u
summarize DNSP Year ceff ceff_l ceff_u

generate cefftl=ceff

drop ci ci_u ci_l ceff ceff_l ceff_u

list cefftl ceffcd
summarize DNSP Year cefftl ceffcd

matrix bh3=e(b)
matlist bh3
matrix e1=c*0
matrix e2=c*bh3[1,1]+ly1*0+ly2*bh3[1,4]+ly3*bh3[1,5]+ly4*bh3[1,6]
matrix e3=c*bh3[1,2]+ly1*0+ly2*bh3[1,5]+ly3*bh3[1,7]+ly4*bh3[1,8]
matrix e4=c*bh3[1,3]+ly1*0+ly2*bh3[1,6]+ly3*bh3[1,8]+ly4*bh3[1,9]
matrix elas = e1, e2, e3, e4
matrix list elas


*xtpcse lvc ly1-ly4 lz1 yr cd2 cd3, c(a) het
*regress lvc ly1-ly4 lz1 yr cd2 cd3
*summarize lvc ly1-ly4 lz1 yr cd2 cd3

*constraint 1 [mu]_cons = 0
*xtfrontier lvc ly1-ly4 lz1 yr cd2 cd3, ti cost constraints(1)

*qui reg lvc ly1-ly4 ly11 ly12 ly13 ly14 ly22 ly23 ly24 ly33 ly34 ly44 lz1 yr cd2 cd3
*matrix b0 = e(b), .1, ln(e(rmse)^2) , .1
*xtfrontier lvc ly1-ly4 ly11 ly12 ly13 ly14 ly22 ly23 ly24 ly33 ly34 ly44 lz1 yr cd2 cd3, ti cost from(b0, copy)


log close
